type
  TWebBrowserEx=class(TWebBrowser)
  private
   FBeforeLoadFromStream:TWebBrowserNotifyEvent;
   FBeforeDestroy      :TWebBrowserNotifyEvent;
   FUserMode           :WordBool;
   FURL                :string;
   FControlBorder      :TControlBorder;
   FShowScrollBar      :Boolean;
   FFlatScrollBar      :Boolean;
   FHTMLSelectionObject:IHTMLSelectionObject;
   FHasFocus           :Boolean;
   FDocEventDispatch   :TDocEventDispatch;
   FWndEventDispatch   :TWndEventDispatch;
   FWebBrowserEvents2Dispatch:TWebBrowserEvents2Dispatch;
   FChangeLog          :IHTMLChangeLog;
   FDocEventDispatchCounter:IInterface;
   FWndEventDispatchCounter:IInterface;
   FWebBrowserEvents2DispatchCounter:IInterface;
   FOnMouseOut         :TMouseMoveEvent;
   FOnMouseOver        :TMouseMoveEvent;
   FAfterUpdate        :TNotifyEvent;
   FBeforeUpdate       :TNotifyEvent;
   FOnError            :TNotifyEvent;
   FOnSelectStart      :TNotifyEvent;
   FOnRowExit          :TNotifyEvent;
   FOnRowEnter         :TNotifyEvent;
   FOnErrorUpdate      :TNotifyEvent;
   FOnLoad             :TNotifyEvent;
   FOnHelp             :TNotifyEvent;
   FOnUnLoad           :TNotifyEvent;
   FOnFocus            :TNotifyEvent;
   FOnBlur             :TNotifyEvent;
   FOnScroll           :TNotifyEvent;
   FOnWndResize        :TNotifyEvent;
   FBeforeUnload       :TNotifyEvent;
   FOnDocWndActivate   :TWndActivateEvent;
   FOnFrameWndActivate :TWndActivateEvent;
   FServiceProviders   :TComponentList;
   FCommandUpdater     :TCustomWebBrowserCommandUpdater;
   FOnReadyStateChange :TNotifyEvent;
   FOnGetExternalDispatch:TGetExternalDispatchEvent;
   FOnStatusTextChange :TStatusTextChangeEvent;
   FOnSelectionChange  :TWebBrowserEvent;
   FOnUpdateCommands   :TNotifyEvent;
   FOnCancelMode       :TNotifyEvent;
   FOnGetDropTarget    :TGetDropTargetEvent;
   FOnWindowClosing    :TWindowClosingEvent;
   FDisplayServices    :IDisplayServices;
   FCaret              :IHTMLCaret;
   FMarkupServices     :IMarkupServices2;
   FPrimarySelectionServices:ISelectionServices;
   FDefInetExplorerServerProc:Pointer;
   FDefShellObjViewProc:Pointer;
   FShellDocObjViewHandle:NativeUInt;
   FInetExplorerServerHandle:NativeUInt;
   FShellDocObjInstance:Pointer;
   FInetExplorerServerInstance:Pointer;
   FUseDivBlock        :Boolean;
   FUseTheme           :Boolean;
   FHooksSet           :Boolean;
   FAutoComplete       :Boolean;
   FOnControlSelect    :TControlSelectEvent;
   FOnResolveRelativePath:TResolveRelativePathEvent;
   FOnShowContextMenu  :TShowContextMenuEvent;
   FOnInitMenuPopup    :TInitMenuPopupEvent;
   FOnOpenNewWindow    :TNotifyEvent;
   FOnReloadDocument   :TWebBrowserNotifyEvent;
   FOnControlMove      :TControlMoveEvent;
   FOnControlResize    :TControlResizeEvent;
   FBaseURL            :string;
   FOnChange           :TNotifyEvent;
   FOnGetSelectionObject:TGetSelectionObjectEvent;
   FOnGetActiveDocument:TGetActiveDocumentEvent;
   FOnGetViewLinkDocuments:TGetViewLinkDocumentsEvent;
   FOnGetElementOfViewLinkDocument:TGetElementOfViewLinkDocumentEvent;
   FOnGetIsEditableElement:TGetIsEditableElementEvent;
   FOnGetIsContentPage :TGetIsContentPageEvent;
   FOnBeforeEditFocus  :TWebBrowserEventWordBool;
   FOnGetHostInfo      :TGetHostInfoEvent;
   FOnGetAmbientControlInfo:TGetAmbientControlEvent;
   FOnPreProcessMessage:TPreProcessMessageEvent;
   FOnInterceptMouseMessage:TInterceptMouseMessageEvent;
   FCurrentElement     :IHTMLElement;
   FCurrentElementType :TCurrentElementType;
   FLastUrl            :WideString;
   FOnStatusTextChange :TWebBrowserStatusTextChange;
   FOnProgressChange   :TWebBrowserProgressChange;
   FOnCommandStateChange:TWebBrowserCommandStateChange;
   FOnDownloadBegin    :TNotifyEvent;
   FOnDownloadComplete :TNotifyEvent;
   FOnTitleChange      :TWebBrowserTitleChange;
   FOnPropertyChange   :TWebBrowserPropertyChange;
   FOnBeforeNavigate2  :TWebBrowserBeforeNavigate2;
   FOnNewWindow2       :TWebBrowserNewWindow2;
   FOnNavigateComplete2:TWebBrowserNavigateComplete2;
   FOnDocumentComplete :TWebBrowserDocumentComplete;
   FOnQuit             :TNotifyEvent;
   FOnVisible          :TWebBrowserOnVisible;
   FOnToolBar          :TWebBrowserOnToolBar;
   FOnMenuBar          :TWebBrowserOnMenuBar;
   FOnStatusBar        :TWebBrowserOnStatusBar;
   FOnFullScreen       :TWebBrowserOnFullScreen;
   FOnTheaterMode      :TWebBrowserOnTheaterMode;
   FOnWindowSetResizable:TWebBrowserWindowSetResizable;
   FOnWindowSetLeft    :TWebBrowserWindowSetLeft;
   FOnWindowSetTop     :TWebBrowserWindowSetTop;
   FOnWindowSetWidth   :TWebBrowserWindowSetWidth;
   FOnWindowSetHeight  :TWebBrowserWindowSetHeight;
   FOnWindowClosing    :TWebBrowserWindowClosing;
   FOnClientToHostWindow:TWebBrowserClientToHostWindow;
   FOnSetSecureLockIcon:TWebBrowserSetSecureLockIcon;
   FOnFileDownload     :TWebBrowserFileDownload;
   FOnNavigateError    :TWebBrowserNavigateError;
   FOnPrintTemplateInstantiation:TWebBrowserPrintTemplateInstantiation;
   FOnPrintTemplateTeardown:TWebBrowserPrintTemplateTeardown;
   FOnUpdatePageStatus :TWebBrowserUpdatePageStatus;
   FOnPrivacyImpactedStateChange:TWebBrowserPrivacyImpactedStateChange;
   FOnNewWindow3       :TWebBrowserNewWindow3;
   FOnSetPhishingFilterStatus:TWebBrowserSetPhishingFilterStatus;
   FOnWindowStateChanged:TWebBrowserWindowStateChanged;
   FOnNewProcess       :TWebBrowserNewProcess;
   FOnThirdPartyUrlBlocked:TWebBrowserThirdPartyUrlBlocked;
   FOnRedirectXDomainBlocked:TWebBrowserRedirectXDomainBlocked;
   FIntf               :IWebBrowser2;
   FControlData        :PControlData;
   FRefCount           :Integer;
   FEventDispatch      :TEventDispatch;
   FObjectData         :NativeUInt;
   FOleObject          :IOleObject;
   FPersistStream      :IPersistStreamInit;
   FOleControl         :IOleControl;
   FControlDispatch    :IDispatch;
   FPropBrowsing       :IPerPropertyBrowsing;
   FOleInPlaceObject   :IOleInPlaceObject;
   FOleInPlaceActiveObject:IOleInPlaceActiveObject;
   FPropConnection     :Integer;
   FEventsConnection   :Integer;
   FMiscStatus         :Integer;
   FFonts              :TList;
   FPictures           :TList;
   FUpdatingPictures   :Boolean;
   FUpdatingColor      :Boolean;
   FUpdatingFont       :Boolean;
   FUpdatingEnabled    :Boolean;
   FServiceQuery       :TServiceQuery;
   FControlInfo        :tagCONTROLINFO;
   FAlignControlList   :TList;
   FAlignLevel         :Word;
   FBevelEdges         :TBevelEdges;
   FBevelInner         :TBevelCut;
   FBevelOuter         :TBevelCut;
   FBevelKind          :TBevelKind;
   FBevelWidth         :TBevelWidth;
   FBorderWidth        :TBorderWidth;
   FPadding            :TPadding;
   FBrush              :TBrush;
   FDockClients        :TList;
   FDockManager        :IDockManager;
   FImeMode            :TImeMode;
   FImeName            :TImeName;
   FParentWindow       :HWND;
   FTabList            :TList;
   FControls           :TList;
   FWinControls        :TList;
   FTabOrder           :Integer;
   FTabStop            :Boolean;
   FCtl3D              :Boolean;
   FShowing            :Boolean;
   FUseDockManager     :Boolean;
   FDockSite           :Boolean;
   FParentCtl3D        :Boolean;
   FParentDoubleBuffered:Boolean;
   FPerformingShowingChanged:Boolean;
   FOnDockDrop         :TDockDropEvent;
   FOnDockOver         :TDockOverEvent;
   FOnEnter            :TNotifyEvent;
   FOnExit             :TNotifyEvent;
   FOnGetSiteInfo      :TGetSiteInfoEvent;
   FOnKeyDown          :TKeyEvent;
   FOnKeyPress         :TKeyPressEvent;
   FOnKeyUp            :TKeyEvent;
   FOnUnDock           :TUnDockEvent;
   FOnAlignInsertBefore:TAlignInsertBeforeEvent;
   FOnAlignPosition    :TAlignPositionEvent;
   FMouseInClient      :Boolean;
   FMouseControl       :TControl;
   FTouchControl       :TControl;
   FDefWndProc         :Pointer;
   FHandle             :HWND;
   FObjectInstance     :Pointer;
   FParent             :TWinControl;
   FWindowProc         :TWndMethod;
   FLeft               :Integer;
   FTop                :Integer;
   FWidth              :Integer;
   FHeight             :Integer;
   FControlStyle       :TControlStyle;
   FControlState       :TControlState;
   FDesktopFont        :Boolean;
   FVisible            :Boolean;
   FEnabled            :Boolean;
   FParentFont         :Boolean;
   FParentColor        :Boolean;
   FAlign              :TAlign;
   FAutoSize           :Boolean;
   FDragMode           :TDragMode;
   FIsControl          :Boolean;
   FBiDiMode           :TBiDiMode;
   FParentBiDiMode     :Boolean;
   FAnchors            :TAnchors;
   FFont               :TFont;
   FActionLink         :TControlActionLink;
   FColor              :TColor;
   FConstraints        :TSizeConstraints;
   FMargins            :TMargins;
   FCursor             :TCursor;
   FDragCursor         :TCursor;
   FPopupMenu          :TPopupMenu;
   FHint               :string;
   FFontHeight         :Integer;
   FScalingFlags       :TScalingFlags;
   FShowHint           :Boolean;
   FParentShowHint     :Boolean;
   FDragKind           :TDragKind;
   FDockOrientation    :TDockOrientation;
   FHostDockSite       :TWinControl;
   FWheelAccumulator   :Integer;
   FUndockWidth        :Integer;
   FUndockHeight       :Integer;
   FLRDockWidth        :Integer;
   FTBDockHeight       :Integer;
   FFloatingDockSiteClass:TWinControlClass;
   FTouchManager       :TTouchManager;
   FOnCanResize        :TCanResizeEvent;
   FOnConstrainedResize:TConstrainedResizeEvent;
   FOnMouseDown        :TMouseEvent;
   FOnMouseMove        :TMouseMoveEvent;
   FOnMouseUp          :TMouseEvent;
   FOnDragDrop         :TDragDropEvent;
   FOnDragOver         :TDragOverEvent;
   FOnResize           :TNotifyEvent;
   FOnStartDock        :TStartDockEvent;
   FOnEndDock          :TEndDragEvent;
   FOnStartDrag        :TStartDragEvent;
   FOnEndDrag          :TEndDragEvent;
   FOnClick            :TNotifyEvent;
   FOnDblClick         :TNotifyEvent;
   FOnContextPopup     :TContextPopupEvent;
   FOnMouseActivate    :TMouseActivateEvent;
   FOnMouseLeave       :TNotifyEvent;
   FOnMouseEnter       :TNotifyEvent;
   FOnMouseWheel       :TMouseWheelEvent;
   FOnMouseWheelDown   :TMouseWheelUpDownEvent;
   FOnMouseWheelUp     :TMouseWheelUpDownEvent;
   FOnGesture          :TGestureEvent;
   FHelpType           :THelpType;
   FHelpKeyword        :string;
   FHelpContext        :THelpContext;
   FCustomHint         :TCustomHint;
   FParentCustomHint   :Boolean;
   FText               :PWideChar;
   FOwner              :TComponent;
   FName               :TComponentName;
   FTag                :NativeInt;
   FComponents         :TList;
   FFreeNotifies       :TList;
   FDesignInfo         :Integer;
   FComponentState     :TComponentState;
   FVCLComObject       :Pointer;
   FObservers          :TObservers;
   FSortedComponents   :TList;
   function GetTag(Index: Integer): IHTMLElement;
   function GetDockClients(Index: Integer): TControl;
   function GetControl(Index: Integer): TControl;
   function GetComponent(AIndex: Integer): TComponent;
  protected
   FBackEnabled        :Boolean;
   FForwardEnabled     :Boolean;
   FDoubleBuffered     :Boolean;
   FInImeComposition   :Boolean;
   FDesignSize         :TPoint;
   FAnchorMove         :Boolean;
   FAnchorRules        :TPoint;
   FAnchorOrigin       :TPoint;
   FOriginalParentSize :TPoint;
   FExplicitLeft       :Integer;
   FExplicitTop        :Integer;
   FExplicitWidth      :Integer;
   FExplicitHeight     :Integer;
   FReserved           :Pointer;
   FComponentStyle     :TComponentStyle;
  public
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   function PreProcessMessage(var Msg: tagMSG): Boolean;
   procedure DoCommand(const CmdStr: string);
   procedure DoCommand(const Cmd: TOleEnum; InParam: OleVariant; OutParam: OleVariant);
   function CommandState(const CmdID: TOleEnum): TCommandStates;
   function CommandState(Cmds: TCommandStateArray): TCommandStateArray;
   function ShowContextMenu(dwID: Cardinal; ppt: PtagPoint; const pcmdtReserved: IInterface; const pdispReserved: IDispatch): HRESULT;
   procedure ForceSelectionChange;
   procedure Bold;
   function Focused: Boolean;
   procedure Italic;
   procedure Underline;
   procedure CutToClipBoard;
   procedure CopyToClipBoard;
   procedure PasteFromClipBoard;
   procedure Delete;
   procedure Undo;
   procedure Redo;
   procedure SelectAll;
   procedure Clear;
   function SelLength: Integer;
   function Selection: IHTMLSelectionObject;
   procedure CreateBookmark;
   procedure Overwrite;
   function GetViewLinkDocuments(CmdId: TOleEnum): IInterfaceList;
   function GetElementOfViewLinkDocument(ADocument: IHTMLDocument): IHTMLElement;
   function GetIsEditableElement(AElement: IHTMLElement; AFlags: TElementEditableFlags): Boolean;
   function GetIsContentPage: Boolean;
   procedure Print;
   procedure PageSetup;
   procedure PrintPreview;
   procedure ClearDirtyFlag;
   procedure Open;
   procedure Save;
   procedure SaveAs;
   procedure LoadFromStream(S: TStream);
   procedure LoadFromFile(const FileName: string);
   procedure SaveToStream(S: TStream);
   procedure SaveToFile(const FileName: string);
   procedure ViewSource;
   function GetSelectionServices: ISelectionServices;
   procedure RegisterServiceProvider(Provider: TWebBrowserServiceProvider);
   procedure UnRegisterServiceProvider(Provider: TWebBrowserServiceProvider);
   procedure GoBack;
   procedure GoForward;
   procedure GoHome;
   procedure GoSearch;
   procedure Navigate(const URL: WideString);
   procedure Navigate(const URL: WideString; const Flags: OleVariant);
   procedure Navigate(const URL: WideString; const Flags: OleVariant; const TargetFrameName: OleVariant);
   procedure Navigate(const URL: WideString; const Flags: OleVariant; const TargetFrameName: OleVariant; const PostData: OleVariant);
   procedure Navigate(const URL: WideString; const Flags: OleVariant; const TargetFrameName: OleVariant; const PostData: OleVariant; const Headers: OleVariant);
   procedure Refresh;
   procedure Refresh2;
   procedure Refresh2(const Level: OleVariant);
   procedure Stop;
   procedure Quit;
   procedure ClientToWindow(var pcx: Integer; var pcy: Integer);
   procedure PutProperty(const Property_: WideString; vtValue: OleVariant);
   function GetProperty(const Property_: WideString): OleVariant;
   procedure Navigate2(const URL: OleVariant);
   procedure Navigate2(const URL: OleVariant; const Flags: OleVariant);
   procedure Navigate2(const URL: OleVariant; const Flags: OleVariant; const TargetFrameName: OleVariant);
   procedure Navigate2(const URL: OleVariant; const Flags: OleVariant; const TargetFrameName: OleVariant; const PostData: OleVariant);
   procedure Navigate2(const URL: OleVariant; const Flags: OleVariant; const TargetFrameName: OleVariant; const PostData: OleVariant; const Headers: OleVariant);
   function QueryStatusWB(cmdID: TOleEnum): TOleEnum;
   procedure ExecWB(cmdID: TOleEnum; cmdexecopt: TOleEnum);
   procedure ExecWB(cmdID: TOleEnum; cmdexecopt: TOleEnum; const pvaIn: OleVariant);
   procedure ExecWB(cmdID: TOleEnum; cmdexecopt: TOleEnum; const pvaIn: OleVariant; var pvaOut: OleVariant);
   procedure ShowBrowserBar(const pvaClsid: OleVariant);
   procedure ShowBrowserBar(const pvaClsid: OleVariant; const pvarShow: OleVariant);
   procedure ShowBrowserBar(const pvaClsid: OleVariant; const pvarShow: OleVariant; const pvarSize: OleVariant);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BrowseProperties;
   procedure DefaultHandler(var Message);
   procedure DoObjectVerb(Verb: Integer);
   function GetEnumPropDesc(DispID: Integer): TEnumPropDesc;
   function GetHelpContext(Member: string; var HelpCtx: Integer; var HelpFile: string): Boolean;
   procedure GetObjectVerbs(List: TStrings);
   function GetPropDisplayString(DispID: Integer): string;
   procedure GetPropDisplayStrings(DispID: Integer; List: TStrings);
   function IsCustomProperty(DispID: Integer): Boolean;
   function IsPropPageProperty(DispID: Integer): Boolean;
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetPropDisplayString(DispID: Integer; const Value: string);
   procedure ShowAboutBox;
   constructor Create(AOwner: TComponent);
   constructor CreateParented(ParentWindow: HWND);
   class function CreateParentedControl(ParentWindow: HWND): TWinControl;
   class destructor Destroy;
   procedure Broadcast(var Message);
   function CanFocus: Boolean;
   function ContainsControl(Control: TControl): Boolean;
   function ControlAtPos(const Pos: TPoint; AllowDisabled: Boolean; AllowWinControls: Boolean; AllLevels: Boolean): TControl;
   procedure DefaultHandler(var Message);
   procedure DisableAlign;
   procedure DockDrop(Source: TDragDockObject; X: Integer; Y: Integer);
   procedure EnableAlign;
   function FindChildControl(const ControlName: string): TControl;
   procedure FlipChildren(AllLevels: Boolean);
   function Focused: Boolean;
   procedure GetChildren(Proc: TGetChildProc = procedure(Child: TComponent) of object; Root: TComponent);
   procedure GetTabControlList(List: TList);
   procedure GetTabOrderList(List: TList);
   function HandleAllocated: Boolean;
   procedure HandleNeeded;
   procedure InsertControl(AControl: TControl);
   procedure Invalidate;
   procedure PaintTo(DC: HDC; X: Integer; Y: Integer);
   procedure PaintTo(Canvas: TCanvas; X: Integer; Y: Integer);
   function PreProcessMessage(var Msg: tagMSG): Boolean;
   procedure RemoveControl(AControl: TControl);
   procedure Realign;
   procedure Repaint;
   procedure ScaleBy(M: Integer; D: Integer);
   procedure ScrollBy(DeltaX: Integer; DeltaY: Integer);
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetFocus;
   procedure Update;
   procedure UpdateControlState;
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeginDrag(Immediate: Boolean; Threshold: Integer);
   procedure BringToFront;
   function ClientToScreen(const Point: TPoint): TPoint;
   function ClientToParent(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure Dock(NewDockSite: TWinControl; ARect: TRect);
   function Dragging: Boolean;
   procedure DragDrop(Source: TObject; X: Integer; Y: Integer);
   function DrawTextBiDiModeFlags(Flags: Integer): Integer;
   function DrawTextBiDiModeFlagsReadingOnly: Integer;
   procedure EndDrag(Drop: Boolean);
   function GetControlsAlignment: TAlignment;
   function GetParentComponent: TComponent;
   function HasParent: Boolean;
   procedure Hide;
   procedure InitiateAction;
   procedure Invalidate;
   procedure MouseWheelHandler(var Message: TMessage);
   function IsRightToLeft: Boolean;
   function ManualDock(NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ManualFloat(ScreenPos: TRect): Boolean;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: NativeInt): NativeInt;
   procedure Refresh;
   procedure Repaint;
   function ReplaceDockedControl(Control: TControl; NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ScreenToClient(const Point: TPoint): TPoint;
   function ParentToClient(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure SendToBack;
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetParentComponent(Value: TComponent);
   procedure Show;
   procedure Update;
   function UseRightToLeftAlignment: Boolean;
   function UseRightToLeftReading: Boolean;
   function UseRightToLeftScrollBar: Boolean;
   procedure DefaultHandler(var Message);
   function GetTextBuf(Buffer: PWideChar; BufSize: Integer): Integer;
   function GetTextLen: Integer;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: PWideChar): NativeInt;
   function Perform(Msg: Cardinal; WParam: NativeUInt; var LParam: TRect): NativeInt;
   procedure SetTextBuf(Buffer: PWideChar);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeforeDestruction;
   procedure DestroyComponents;
   procedure Destroying;
   function ExecuteAction(Action: TBasicAction): Boolean;
   function FindComponent(const AName: string): TComponent;
   procedure FreeNotification(AComponent: TComponent);
   procedure RemoveFreeNotification(AComponent: TComponent);
   procedure FreeOnRelease;
   function GetEnumerator: TComponentEnumerator;
   function GetParentComponent: TComponent;
   function GetNamePath: string;
   function HasParent: Boolean;
   procedure InsertComponent(AComponent: TComponent);
   procedure RemoveComponent(AComponent: TComponent);
   procedure SetSubComponent(IsSubComponent: Boolean);
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   function UpdateAction(Action: TBasicAction): Boolean;
   function IsImplementorOf(const I: IInterface): Boolean;
   function ReferenceInterface(const I: IInterface; Operation: TOperation): Boolean;
   class destructor Destroy;
   procedure Assign(Source: TPersistent);
   function GetNamePath: string;
   constructor Create;
   procedure Free;
   class function InitInstance(Instance: Pointer): TObject;
   procedure CleanupInstance;
   function ClassType: TClass;
   class function ClassName: string;
   class function ClassNameIs(const Name: string): Boolean;
   class function ClassParent: TClass;
   class function ClassInfo: Pointer;
   class function InstanceSize: Integer;
   class function InheritsFrom(AClass: TClass): Boolean;
   class function MethodAddress(const Name: ShortString): Pointer;
   class function MethodAddress(const Name: string): Pointer;
   class function MethodName(Address: Pointer): string;
   class function QualifiedClassName: string;
   function FieldAddress(const Name: ShortString): Pointer;
   function FieldAddress(const Name: string): Pointer;
   function GetInterface(const IID: TGUID; out Obj): Boolean;
   class function GetInterfaceEntry(const IID: TGUID): PInterfaceEntry;
   class function GetInterfaceTable: PInterfaceTable;
   class function UnitName: string;
   class function UnitScope: string;
   function Equals(Obj: TObject): Boolean;
   function GetHashCode: Integer;
   function ToString: string;
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   procedure AfterConstruction;
   procedure BeforeDestruction;
   procedure Dispatch(var Message);
   procedure DefaultHandler(var Message);
   class function NewInstance: TObject;
   procedure FreeInstance;
   class destructor Destroy;
   property BackEnabled: Boolean;
   property Caret: IHTMLCaret;
   property CommandUpdater: TCustomWebBrowserCommandUpdater;
   property ForwardEnabled: Boolean;
   property CommandTarget: IOleCommandTarget;
   property DisplayServices: IDisplayServices;
   property Document2: IHTMLDocument2;
   property Document3: IHTMLDocument3;
   property Document4: IHTMLDocument4;
   property HTMLEditServices: IHTMLEditServices2;
   property HighlightRenderingServices: IHighlightRenderingServices;
   property MarkupServices: IMarkupServices2;
   property Modified: Boolean;
   property Namespaces: IHTMLNamespaceCollection;
   property OverrideCursor: Boolean;
   property PrimaryMarkupContainer: IMarkupContainer2;
   property ServiceProvider: IServiceProvider;
   property SelectionServices: ISelectionServices;
   property ShellDocObjViewHandle: NativeUInt;
   property InetExplorerServerHandle: NativeUInt;
   property ActiveElement: IHTMLElement;
   property Count: Integer;
   property Window: IHTMLWindow2;
   property DocEvents: TDocEventDispatch;
   property WndEvents: TWndEventDispatch;
   property WebBrowserEvents: TWebBrowserEvents2Dispatch;
   property CurrentElement: IHTMLElement;
   property CurrentElementType: TCurrentElementType;
   property ControlInterface: IWebBrowser2;
   property DefaultInterface: IWebBrowser2;
   property Application: IDispatch;
   property Parent: IDispatch;
   property Container: IDispatch;
   property Document: IDispatch;
   property TopLevelContainer: WordBool;
   property type_: WideString;
   property LocationName: WideString;
   property LocationURL: WideString;
   property Busy: WordBool;
   property Name: WideString;
   property HWND: HWND;
   property FullName: WideString;
   property Path: WideString;
   property ReadyState: TOleEnum;
   property OleObject: Variant;
   property PerPropBrowsing: IPerPropertyBrowsing;
   property DefaultDispatch: IDispatch;
   property TabStop: Boolean;
   property Anchors: TAnchors;
   property ServiceQuery: TServiceQuery;
   property DockClientCount: Integer;
   property DockSite: Boolean;
   property DockManager: IDockManager;
   property DoubleBuffered: Boolean;
   property AlignDisabled: Boolean;
   property MouseInClient: Boolean;
   property VisibleDockClientCount: Integer;
   property Brush: TBrush;
   property ControlCount: Integer;
   property Handle: HWND;
   property Padding: TPadding;
   property ParentDoubleBuffered: Boolean;
   property ParentWindow: HWND;
   property Showing: Boolean;
   property TabOrder: TTabOrder;
   property TabStop: Boolean;
   property UseDockManager: Boolean;
   property Enabled: Boolean;
   property Action: TBasicAction;
   property Align: TAlign;
   property Anchors: TAnchors;
   property BiDiMode: TBiDiMode;
   property BoundsRect: TRect;
   property ClientHeight: Integer;
   property ClientOrigin: TPoint;
   property ClientRect: TRect;
   property ClientWidth: Integer;
   property Constraints: TSizeConstraints;
   property ControlState: TControlState;
   property ControlStyle: TControlStyle;
   property DockOrientation: TDockOrientation;
   property ExplicitLeft: Integer;
   property ExplicitTop: Integer;
   property ExplicitWidth: Integer;
   property ExplicitHeight: Integer;
   property Floating: Boolean;
   property FloatingDockSiteClass: TWinControlClass;
   property HostDockSite: TWinControl;
   property LRDockWidth: Integer;
   property ShowHint: Boolean;
   property TBDockHeight: Integer;
   property Touch: TTouchManager;
   property UndockHeight: Integer;
   property UndockWidth: Integer;
   property Visible: Boolean;
   property WindowProc: TWndMethod;
   property Parent: TWinControl;
   property OnGesture: TGestureEvent;
   property ComObject: IInterface;
   property ComponentCount: Integer;
   property ComponentIndex: Integer;
   property ComponentState: TComponentState;
   property ComponentStyle: TComponentStyle;
   property DesignInfo: Integer;
   property Owner: TComponent;
   property VCLComObject: Pointer;
   property Observers: TObservers;
  published
   property AutoComplete: Boolean;
   property ActiveDocument: IHTMLDocument;
   property BaseURL: string;
   property BeforeDestroy: TWebBrowserNotifyEvent;
   property Constraints: TSizeConstraints;
   property FlatScrollBar: Boolean;
   property ShowScrollBar: Boolean;
   property ControlBorder: TControlBorder;
   property UserMode: WordBool;
   property UseDivBlock: Boolean;
   property UseTheme: Boolean;
   property URL: string;
   property BeforeLoadFromStream: TWebBrowserNotifyEvent;
   property BeforeUpdate: TNotifyEvent;
   property AfterUpdate: TNotifyEvent;
   property OnChange: TNotifyEvent;
   property OnDblClick: TNotifyEvent;
   property OnCancelMode: TNotifyEvent;
   property OnClick: TNotifyEvent;
   property OnError: TNotifyEvent;
   property OnErrorUpdate: TNotifyEvent;
   property OnGetAmbientControlInfo: TGetAmbientControlEvent;
   property OnGetHostInfo: TGetHostInfoEvent;
   property OnReloadDocument: TWebBrowserNotifyEvent;
   property OnResolveRelativePath: TResolveRelativePathEvent;
   property OnPreprocessMessage: TPreProcessMessageEvent;
   property OnInterceptMouseMessage: TInterceptMouseMessageEvent;
   property OnDocWndActivate: TWndActivateEvent;
   property OnFrameWndActivate: TWndActivateEvent;
   property OnGetExternalDispatch: TGetExternalDispatchEvent;
   property OnStatusTextChange: TStatusTextChangeEvent;
   property OnGetDropTarget: TGetDropTargetEvent;
   property OnGetSelectionObject: TGetSelectionObjectEvent;
   property OnGetActiveDocument: TGetActiveDocumentEvent;
   property OnGetViewLinkDocuments: TGetViewLinkDocumentsEvent;
   property OnGetElementOfViewLinkDocument: TGetElementOfViewLinkDocumentEvent;
   property OnGetIsEditableElement: TGetIsEditableElementEvent;
   property OnGetIsContentPage: TGetIsContentPageEvent;
   property OnShowContextMenu: TShowContextMenuEvent;
   property OnInitMenuPopup: TInitMenuPopupEvent;
   property OnOpenNewWindow: TNotifyEvent;
   property OnWindowClosing: TWindowClosingEvent;
   property BeforeUnload: TNotifyEvent;
   property OnBlur: TNotifyEvent;
   property OnHelp: TNotifyEvent;
   property OnLoad: TNotifyEvent;
   property OnUnLoad: TNotifyEvent;
   property OnWndResize: TNotifyEvent;
   property OnScroll: TNotifyEvent;
   property OnReadyStateChange: TNotifyEvent;
   property OnSelectionChange: TWebBrowserEvent;
   property OnBeforeEditFocus: TWebBrowserEventWordBool;
   property OnUpdateCommands: TNotifyEvent;
   property OnControlSelect: TControlSelectEvent;
   property OnMouseMove: TMouseMoveEvent;
   property OnMouseDown: TMouseEvent;
   property OnMouseOut: TMouseMoveEvent;
   property OnMouseOver: TMouseMoveEvent;
   property OnRowEnter: TNotifyEvent;
   property OnRowExit: TNotifyEvent;
   property OnSelectStart: TNotifyEvent;
   property OnKeyDown: TKeyEvent;
   property OnKeyPress: TKeyPressEvent;
   property OnKeyUp: TKeyEvent;
   property OnControlMove: TControlMoveEvent;
   property OnControlResize: TControlResizeEvent;
   property Anchors: TAnchors;
   property TabStop: Boolean;
   property Align: TAlign;
   property DragCursor: TCursor;
   property DragMode: TDragMode;
   property ParentShowHint: Boolean;
   property PopupMenu: TPopupMenu;
   property ShowHint: Boolean;
   property TabOrder: TTabOrder;
   property OnDragDrop: TDragDropEvent;
   property OnDragOver: TDragOverEvent;
   property OnEndDrag: TEndDragEvent;
   property OnEnter: TNotifyEvent;
   property OnExit: TNotifyEvent;
   property OnStartDrag: TStartDragEvent;
   property Visible: WordBool;
   property StatusBar: WordBool;
   property StatusText: WideString;
   property ToolBar: Integer;
   property MenuBar: WordBool;
   property FullScreen: WordBool;
   property Offline: WordBool;
   property Silent: WordBool;
   property RegisterAsBrowser: WordBool;
   property RegisterAsDropTarget: WordBool;
   property TheaterMode: WordBool;
   property AddressBar: WordBool;
   property Resizable: WordBool;
   property OnStatusTextChange: TWebBrowserStatusTextChange;
   property OnProgressChange: TWebBrowserProgressChange;
   property OnCommandStateChange: TWebBrowserCommandStateChange;
   property OnDownloadBegin: TNotifyEvent;
   property OnDownloadComplete: TNotifyEvent;
   property OnTitleChange: TWebBrowserTitleChange;
   property OnPropertyChange: TWebBrowserPropertyChange;
   property OnBeforeNavigate2: TWebBrowserBeforeNavigate2;
   property OnNewWindow2: TWebBrowserNewWindow2;
   property OnNavigateComplete2: TWebBrowserNavigateComplete2;
   property OnDocumentComplete: TWebBrowserDocumentComplete;
   property OnQuit: TNotifyEvent;
   property OnVisible: TWebBrowserOnVisible;
   property OnToolBar: TWebBrowserOnToolBar;
   property OnMenuBar: TWebBrowserOnMenuBar;
   property OnStatusBar: TWebBrowserOnStatusBar;
   property OnFullScreen: TWebBrowserOnFullScreen;
   property OnTheaterMode: TWebBrowserOnTheaterMode;
   property OnWindowSetResizable: TWebBrowserWindowSetResizable;
   property OnWindowSetLeft: TWebBrowserWindowSetLeft;
   property OnWindowSetTop: TWebBrowserWindowSetTop;
   property OnWindowSetWidth: TWebBrowserWindowSetWidth;
   property OnWindowSetHeight: TWebBrowserWindowSetHeight;
   property OnWindowClosing: TWebBrowserWindowClosing;
   property OnClientToHostWindow: TWebBrowserClientToHostWindow;
   property OnSetSecureLockIcon: TWebBrowserSetSecureLockIcon;
   property OnFileDownload: TWebBrowserFileDownload;
   property OnNavigateError: TWebBrowserNavigateError;
   property OnPrintTemplateInstantiation: TWebBrowserPrintTemplateInstantiation;
   property OnPrintTemplateTeardown: TWebBrowserPrintTemplateTeardown;
   property OnUpdatePageStatus: TWebBrowserUpdatePageStatus;
   property OnPrivacyImpactedStateChange: TWebBrowserPrivacyImpactedStateChange;
   property OnNewWindow3: TWebBrowserNewWindow3;
   property OnSetPhishingFilterStatus: TWebBrowserSetPhishingFilterStatus;
   property OnWindowStateChanged: TWebBrowserWindowStateChanged;
   property OnNewProcess: TWebBrowserNewProcess;
   property OnThirdPartyUrlBlocked: TWebBrowserThirdPartyUrlBlocked;
   property OnRedirectXDomainBlocked: TWebBrowserRedirectXDomainBlocked;
   property AlignWithMargins: Boolean;
   property Left: Integer;
   property Top: Integer;
   property Width: Integer;
   property Height: Integer;
   property Cursor: TCursor;
   property Hint: string;
   property HelpType: THelpType;
   property HelpKeyword: string;
   property HelpContext: THelpContext;
   property Margins: TMargins;
   property CustomHint: TCustomHint;
   property ParentCustomHint: Boolean;
   property Name: TComponentName;
   property Tag: NativeInt;
  end;
